/* - AdvServoDetachListener -
 * Clear all the fields and disable all the controls
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.AdvancedServoPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.DetachListener;
import com.phidgets.event.DetachEvent;

import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.JSlider;

public class AdvServoDetachListener implements DetachListener{
    
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numServosTxt;
    private JComboBox servoCmb;
    private JComboBox servoTypeCmb;
    private JTextField actVelTxt;
    private JTextField actPosTxt;
    private JTextField currentTxt;
    private JSlider posScrl;
    private JTextField targetPosTxt;
    private JSlider velScrl;
    private JTextField targetVelTxt;
    private JSlider accelScrl;
    private JTextField accelTxt;
    private JCheckBox engagedChk;
    private JCheckBox rampingChk;
    private JSlider maxPosScrl;
    private JTextField maxPosTxt;
    private JSlider minPosScrl;
    private JTextField minPosTxt;
    private JCheckBox stoppedChk;
    
    /** Creates a new instance of AdvServoDetachListener */
    public AdvServoDetachListener(JFrame appFrame, JTextField attachedTxt, 
            JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt, 
            JTextField numServosTxt, JComboBox servoCmb, JComboBox servoTypeCmb, 
            JTextField actVelTxt, JTextField actPosTxt, JTextField currentTxt, 
            JSlider posScrl, JTextField targetPosTxt, JSlider velScrl, 
            JTextField targetVelTxt, JSlider accelScrl, JTextField accelTxt, 
            JCheckBox engagedChk, JCheckBox rampingChk, JSlider maxPosScrl, 
            JTextField maxPosTxt, JSlider minPosScrl, JTextField minPosTxt, 
            JCheckBox stoppedChk)
    {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numServosTxt = numServosTxt;
        this.servoCmb = servoCmb;
        this.servoTypeCmb = servoTypeCmb;
        this.actVelTxt = actVelTxt;
        this.actPosTxt = actPosTxt;
        this.currentTxt = currentTxt;
        this.posScrl = posScrl;
        this.targetPosTxt = targetPosTxt;
        this.velScrl = velScrl;
        this.targetVelTxt = targetVelTxt;
        this.accelScrl = accelScrl;
        this.accelTxt = accelTxt;
        this.engagedChk = engagedChk;
        this.rampingChk = rampingChk;
        this.maxPosScrl = maxPosScrl;
        this.maxPosTxt = maxPosTxt;
        this.minPosScrl = minPosScrl;
        this.minPosTxt = minPosTxt;
        this.stoppedChk = stoppedChk;
    }

    public void detached(DetachEvent de)
    {
        try
        {
            AdvancedServoPhidget detached = (AdvancedServoPhidget)de.getSource();
            attachedTxt.setText(Boolean.toString(detached.isAttached()));
            nameTxt.setText("");
            serialTxt.setText("");
            versionTxt.setText("");
            numServosTxt.setText("");
            actPosTxt.setText("");
            actVelTxt.setText("");
            currentTxt.setText("");
            
            engagedChk.setEnabled(false);
            rampingChk.setEnabled(false);
            
            maxPosScrl.setEnabled(false);
            maxPosScrl.setValue(maxPosScrl.getMinimum());
            maxPosTxt.setText(Integer.toString(maxPosScrl.getValue()));
            minPosScrl.setEnabled(false);
            minPosScrl.setValue(minPosScrl.getMinimum());
            minPosTxt.setText(Integer.toString(minPosScrl.getValue()));
            posScrl.setEnabled(false);
            posScrl.setValue(posScrl.getMinimum());
            targetPosTxt.setText(Integer.toString(posScrl.getValue()));
            velScrl.setEnabled(false);
            velScrl.setValue(velScrl.getMinimum());
            targetVelTxt.setText(Integer.toString(velScrl.getValue()));
            accelScrl.setEnabled(false);
            accelScrl.setValue(accelScrl.getMinimum());
            accelTxt.setText(Integer.toString(accelScrl.getValue()));
            
            servoCmb.setEnabled(false);
            servoCmb.removeAllItems();
        }
        catch (PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
